function JKLKLayer(seq,config){
	LayerBase.call(this,seq,config);
}

JKLKLayer.prototype = Object.create(LayerBase.prototype);  

JKLKLayer.prototype.OnMapChange = function(){
	if(this.isChecked) this.loadLayerData();
}

JKLKLayer.prototype.loadLayerData = function(){
	var that = this ,layers = MapToolBar.getLayerCollection();
	if(layers){
		var model = LayerBase.getBaseQueryCondition(that.getLayerSeq());
		model.page = 1;
		model.rows = 10000;
		model.LIKExzbh = "";
		model.LIKElkmc = "";
		$.ajax({
			type:'post',
			dataType : 'json',
			data:model,
			url:'szMapHttpAction!getMapGridData.do',
			success:function(data){
			 	if(data && data.rows.length ){
			 		that.tryCloseCurrPopUpHtmlWindow(data.rows);
				    that.removeMarkers();
			 		console.log( "JKLKLayer data length:"+data.rows.length);
			 		var i = 0 ;
			 		while(data.rows[i] && data.rows[i].lkmc){
				 		that.drawMarker(data.rows[i],i);
				 		i++;
			 		}
			 	}
			 }
	    });
	}
}


JKLKLayer.prototype.showCameraOnMap = function(marker){
	MapMain.getEzmap().addOverlay(marker);
}


JKLKLayer.prototype.deleteCameraOnMap = function(marker){
	if( marker){
		//if(!!marker.map) marker.closeInfoWindowHtml();
		MapMain.getEzmap().removeOverlay(marker);
	}		
}

JKLKLayer.prototype.getMark = function(result,withTitle){	
	if(!result) return ;	
	var pIcon 	= this.getIcon(MapConst.MARKER_ICON_JKLK , MapConst.LAYER_ICON_WIDTH ,MapConst.LAYER_ICON_HEIGHT);
	var point		=	new Point(result.jd,result.wd);	
	var resultMsg 	= 	PopUpBase.createMonitorPopUp(result);
	var title 		=  	this.getTitle(result.lkmc);
	var markerObj 	= 	[ this.seq , result.id , result.jd,result.wd ];
	var marker 		= 	new Marker(point,pIcon) ;
	marker.addListener("click", function () {
		MapMain.setCurrPupUpObject(markerObj);
		marker.openInfoWindowHtml(resultMsg);
	});		
	marker.setZIndex(MapConst.MARKER_ZINDEX_MONITOR);	
	return marker;
}

JKLKLayer.prototype.createPopUp = function(data){
	  return PopUpBase.createMonitorPopUp(data);
}